define(['InstitutionsService','localResourceDirectoryService'], function () {
	'use strict';

	describe('The Institutions Service', function () {
		var $scope,
			$http,
			$httpBackend,
			$q,
			service,
			mhpuser,
			mhpuserCallback,
			localResourceDirectoryMock,
			localResourceDirectoryCallback;
			;

		var institution1 = {name:'inst1'}, institution2 = {name:'inst2'};

		beforeEach(function() {
			module('angularTemplateApp');

			localResourceDirectoryMock = {
				fetch: function(){
					return {
						then: function(callback){
							callback({'institutions':'institutions url'})
						}
					};
				}
			};

			mhpuser = {
				fetch: function(){
					return {
						then: function(callback){
							callback({vistaLocation:'501'})
						}
					};
				}
			};

			module(function($provide) {
				$provide.value('mhpuser', mhpuser);
				$provide.value('localResourceDirectoryService', localResourceDirectoryMock);
			});

			inject(function($rootScope, _$httpBackend_, InstitutionsService) {
				$scope = $rootScope;
				$httpBackend = _$httpBackend_;
				service = InstitutionsService;
			});

			$httpBackend.expectGET('institutions url').respond(200,
				[
					institution1, institution2
				]
			);

		});

		it('provides the list of institutions', function() {
			service.then(function(results){
				expect(results.institutions.data).toEqual([institution1,institution2]);
			});

			$scope.$digest();
			$httpBackend.flush();
		});

		it('sets the active institution and retrieves the same institution when asked by the getter', function() {
			service.then(function(results){
				results.setActiveInstitution(results.institutions.data[0]);
				expect(results.getActiveInstitution()).toEqual(institution1)
			});

			$scope.$digest();
			$httpBackend.flush();
		});
	});
});